this.name        = "deep_space_pirates"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 Creative Commons: attribution, non-commercial, sharealike."; 
this.description = "This script places random ships in deep space."; 
this.version     = "1.0"; 
/*
The script does nothing when in interstellar space or when docked or when under attack.
The chance of encounters is less when traveling slow. NB jumpSpeed is about 32 * maxSpeed.
It only add ships when not within "this.spacelaneRadius" meters from the core of: the spacelane planet-witchpoint, the spacelane planet-sun or any station.
Decrease change of encounters logaritmic with distance.
*/

this.logging = false
this.spacelaneRadius = 1E5 // planet radius is between 3000 and 6000, main-station at twice this distance.

this.tickle = function()
{
    if(!system.isInterstellarSpace && !player.ship.docked && player.ship.speed > 20*player.ship.maxSpeed*Math.random() && !player.alertHostiles) 
    this.addPirate()
}

this.addPirate = function()
{
    // first check planet-witchpoint spacelane cylinder.
    var distanceToSpacelane = Math.sqrt(player.ship.position.x * player.ship.position.x + player.ship.position.y * player.ship.position.y)
    var chanceFactor = 0.2/Math.log(distanceToSpacelane/this.spacelaneRadius) // value is nagative up to this.spacelaneRadius.
    // Above this.spacelaneRadius meter distance, chanceFactor starts high but decays gradually.
    if(distanceToSpacelane < 3*this.spacelaneRadius) chanceFactor *= 3 - system.government/3.5 // varies between 1 and 3
    if(chanceFactor < Math.random()) return; // stop further calculations.
    // calculate planet-sun spacelane cylinder.
    var sunSpacelane = new Vector3D(system.mainPlanet.position.subtract(system.sun.position))
    var sunPlayerVector = new Vector3D(player.ship.position.subtract(system.sun.position))
    var distanceToSun = sunPlayerVector.magnitude()
    var distanceToSunSpacelane = distanceToSun * Math.sin(sunSpacelane.angleTo(sunPlayerVector))
    if(distanceToSpacelane > this.spacelaneRadius && distanceToSunSpacelane > this.spacelaneRadius)
    {
        var orientation = player.ship.orientation; 
        var forwardPosition = new Vector3D()
        if(Math.random()  <  0.6 - system.government/20)  // 60% chance of pirate in Anarchie, 25% in Corporate State
        {
            if(system.countShipsWithRole("pirate")>150 || system.shipsWithRole("station", player.ship, 100E3).length > 0) return;
            // no Pirate addition when > 150 or when within 100 000 m of station
            forwardPosition = player.ship.position.add(orientation.vectorForward().multiply(50E3))
            system.legacy_addShipsAtPrecisely("pirate", this.biasedRandom(8), "abs", forwardPosition)
            var pirates = system.shipsWithPrimaryRole("pirate", player.ship, 60E3);
            for (var i=0; i<pirates.length;i++)
            {
                if((clock.absoluteSeconds - pirates[i].spawnTime) < 5) // process only new added ships.
                {
                    if(pirates[i].bounty == 0 && Math.random()>0.2) pirates[i].bounty = Math.round(Math.random()*40)+10
                    // script added pirates are often clean. Make 80% of them offender.
                    if(pirates[i].AI == "pirateAI.plist") pirates[i].switchAI("DSPpirateAI.plist")
                    pirates[i].displayName = pirates[i].displayName + " (ds)" // for debugging purposes. Or keep it in?
                }
            }
            if(distanceToSpacelane < 800E3) pirates[0].AIState = "SPACELANE"
            else pirates[0].AIState = "DEEPSPACE"
        if(this.logging) log("DeepSpacePirate", "Added "+ pirates.length +" pirates")
        }
        else
        {
            if(system.countShipsWithRole("asteroid")>200 || system.shipsWithRole("station", player.ship, 250E3).length > 0) return;
            // no asteroid addition when > 150 or when within 250 000 m of station
            if(this.logging) log("DeepSpacePirate", "Adding asteroids")
            if(Math.random()>0.1)
            {
                forwardPosition = player.ship.position.add(orientation.vectorForward().multiply(90E3))
                system.legacy_addShipsWithinRadius("asteroid", Math.ceil(Math.random()*3), "abs", forwardPosition, 10000)
            }
            else
            {
                forwardPosition = player.ship.position.add(orientation.vectorForward().multiply(200E3))
                system.legacy_addShipsWithinRadius("DSProckhermit", 1, "abs", forwardPosition, 10E3)
                system.legacy_addShipsWithinRadius("asteroid", 8, "abs", forwardPosition, 10E3)
            }
        }
    }
}

this.biasedRandom = function(amount)
{
    return Math.ceil(Math.random()*Math.random()*amount);
}